﻿# RGAS png spriteset extract
# Are you bored for RGAS tool using? extract everything to PNG!
# Raúl Ortega Palacios 2021
#######################################################################################

import json
import codecs
import png
import base64
import sys, getopt
import os

ZXSPECTRUM_COLORS = [
  [0x00, 0x00, 0x00], 
  [0x00, 0x00, 0xD7],
  [0xD7, 0x00, 0x00],
  [0xD7, 0x00, 0xD7],
  [0x00, 0xD7, 0x00],
  [0x00, 0xD7, 0xD7],
  [0xD7, 0xD7, 0x00],
  [0xD7, 0xD7, 0xD7],
  [0x00, 0x00, 0x00],
  [0x00, 0x00, 0xFF],
  [0xFF, 0x00, 0x00],
  [0xFF, 0x00, 0xFF],
  [0x00, 0xFF, 0x00],
  [0x00, 0xFF, 0xFF],
  [0xFF, 0xFF, 0x00],
  [0xFF, 0xFF, 0xFF]
]

AMSTRAD_COLORS = [
  (0x00, 0x00, 0x00),
  (0x00, 0x00, 0x80),
  (0x00, 0x00, 0xFF),
  (0x80, 0x00, 0x00),
  (0x80, 0x00, 0x80),
  (0x80, 0x00, 0xFF),
  (0xFF, 0x00, 0x00),
  (0xFF, 0x00, 0x80),
  (0xFF, 0x00, 0xFF),
  (0x00, 0x80, 0x00),
  (0x00, 0x80, 0x80),
  (0x00, 0x80, 0xFF),
  (0x80, 0x80, 0x00),
  (0x80, 0x80, 0x80),
  (0x80, 0x80, 0xFF),
  (0xFF, 0x80, 0x00),
  (0xFF, 0x80, 0x80),
  (0xFF, 0x80, 0xFF),
  (0x00, 0xFF, 0x00),
  (0x00, 0xFF, 0x80),
  (0x00, 0xFF, 0xFF),
  (0x80, 0xFF, 0x00),
  (0x80, 0xFF, 0x80),
  (0x80, 0xFF, 0xFF),
  (0xFF, 0xFF, 0x00),
  (0xFF, 0xFF, 0x80),
  (0xFF, 0xFF, 0xFF)
]


def main(argv):
  # Arguments evaluate
  ##################################
  inputfiles = []
  outputdir = ''
  try:
      opts, args = getopt.getopt(argv, "hi:o:", ["ifile=", "odir="])
  except getopt.GetoptError:
      print('rgastopng.py -i <inputfile> -o <outputdir>')
      sys.exit(2)
  for opt, arg in opts:
      if opt == '-h':
          print('rgastopng.py -i <inputfile> -o <outputdir>')
          sys.exit()
      elif opt in ("-i", "--ifile"):
          inputfiles.append(arg)
      elif opt in ("-o", "--odir"):
          outputdir = arg
      
  print('Input file is ', inputfiles)
  print('Output file is ', outputdir)
  
  readJSON(inputfiles, outputdir)

# Read JSON and organize creating directories for insert png files
###################################################################
def readJSON(jsonFiles, outputdir):
  print(jsonFiles)
  
  for file in jsonFiles:
    path = ''

    try:
      if(outputdir != ''):
        path = outputdir
        if(not os.path.isdir(path)):
          os.mkdir(path)
        path += "/"

      path += file.split('.')[0]
      if(not os.path.isdir(path)):
        os.mkdir(path)
      path += "/"

    except OSError:
      print ("Creation of the directory %s failed" % path)
    else:
      print ("Successfully created the directory %s " % path)
    
    # JSON parse
    with open(file, mode='r', encoding='utf-8-sig') as f:
      contents = f.read()
    
    contents.replace("false", "0")
    contents.replace("true", "1")
    dataJSON = json.loads(contents)
    if( "SpectrumSpriteSet" in dataJSON["$type"] ):
      getPNGSpectrum(dataJSON, path)
    elif( "AmstradSpriteSet" in dataJSON["$type"] ):
      getPNGAmstran(dataJSON, path)

# Sinclair ZX Spectrum PNG extract
##################################
def getPNGSpectrum(dataJSON, path):
  # Images
  for i in dataJSON["_ImageList"]["$values"]:

    # Create enconded Spectrum pixel array 
    pixelsZX = base64.standard_b64decode(i["pixels"]["$value"])
    pixelsRGB = []
    width = i["Width"]
    height = i["Height"]
    hasMask = "MaskDataInline" in i and i["MaskDataInline"] == 1

    print( "Wrtting '" + i["_name"] + "'" )
    # print( str(pixelsZX) )

    # Spectrum to RGB pixels convert
    for row in range(0, height):
      pixelsRGBrow = []
      pixelsRGBrowMask = []
      for column in range(0, width):
        pixelIndex = pixelsZX[(row * width) + column]
        pixelColorPick = ZXSPECTRUM_COLORS[ 0x00 if(hasMask and pixelIndex == 0xFF) else pixelIndex & 0x0F]
        pixelColorPickMask = ZXSPECTRUM_COLORS[(pixelIndex & 0xA0) >> 4]
        for pRGB in range(0, 3):
          # Set png RGB
          pixelsRGBrow.append(pixelColorPick[pRGB])

        if(hasMask):
          for pRGB in range(0, 3):
            # Set png mask
            pixelsRGBrowMask.append(pixelColorPickMask[pRGB])
      
      if(hasMask):
        pixelsRGBrow += pixelsRGBrowMask

      pixelsRGB.append(pixelsRGBrow)

    if(hasMask):
      width *= 2
    with open( path + (i["_name"] if( i["_name"] != "" ) else i["_guid"]) + ".png" , 'wb' ) as f:
      pngFile = png.Writer( width, height, greyscale=0)
      pngFile.write(f, pixelsRGB )

# Amstrad CPC Spectrum PNG extract
##################################
def getPNGAmstran(dataJSON, path):
  # Images
  cpcPalInks = base64.standard_b64decode(dataJSON["Inks"]["$value"])
  cpcPalRGB   = []
  # CPC Pal
  for ink in cpcPalInks:
    cpcPalRGB.append(AMSTRAD_COLORS[ink])

  for i in dataJSON["_ImageList"]["$values"]:
    # Create enconded Spectrum pixel array 
    pixelsCPC = base64.standard_b64decode(i["pixels"]["$value"])
    pixelsRGB = []
    width = i["Width"]
    height = i["Height"]

    print( "Wrtting '" + i["_name"] + "'" )

    # Spectrum to RGB pixels convert
    for row in range(0, height):
      pixelsRGBrow = []
      for column in range(0, width):
        pixelsRGBrow.append(pixelsCPC[(row * width) + column])
        pixelsRGBrow.append(pixelsCPC[(row * width) + column])
      pixelsRGB.append(pixelsRGBrow)

    with open( path + (i["_name"] if( i["_name"] != "" ) else i["_guid"]) + ".png" , 'wb' ) as f:
      pngFile = png.Writer( width * 2, height, greyscale=0, palette=cpcPalRGB, bitdepth=8)
      pngFile.write(f, pixelsRGB )


if __name__ == "__main__":
    main(sys.argv[1:])