;; Resident driver
;;
;; - Amstrad CP/M only (because it relies on specific addresses)
;; - CPM 2.2 only
;; - Uses MOVCPM to allocate space.

include "driver_common.asm"

size_wanted equ end_driver_code-driver_code

;;------------------------------------------------------------------------

org &100

start:
;; check cp/m version
ld c,&0c
call bdos
ld a,l
cp &22
jr z,is_cpm22

;; it's not 2.2
ld hl,msg_not_cpm22
call display_message

;; and quit
ret

;;------------------------------------------------------------------------

is_cpm22:
;; check enough allocated space

ld hl,(1) ;; read wboot
ld de,&33-3
add hl,de
;; HL = end of jump table
ex de,hl

ld hl,&ad33	;; this is upper memory address on CPC
or a
sbc hl,de
;; HL = size of memory available.
ld de,size_wanted
or a
sbc hl,de
bit 7,h
jp p,enough_space
add hl,de

;; TODO: Tell us how much MOVCPM needs to be used

;; HL = space

ld hl,msg_insuffient_space
call display_message
ret

;;------------------------------------------------------------------------

enough_space:
ld hl,(1) ;; read wboot
ld de,&33-3
add hl,de
push hl
ex de,hl
ld hl,driver_code
ld bc,end_driver_code-driver_code
ldir
pop hl
call callhl
ld hl,msg_installed
call display_message
ret
callhl:
jp (hl)
;;------------------------------------------------------------------------

;; ideally this is prl and we relocate it into place.
driver_code:
incbin "driver_code.bin"
end_driver_code

;;------------------------------------------------------------------------

display_char:
push hl
ld c,2			;; console output function id
ld e,a			;; ASCII character
call bdos		;; call BDOS to execute function
pop hl
ret

;;------------------------------------------------------------------------

;; HL = pointer to null terminated message
display_message:
ld a,(hl)				;; get ASCII character
inc hl					;; increment pointer for next character
cp "$"					;; end of message marker
ret z					;; quit if end of message marker found.

call display_char		;; send character to console output
jp display_message		;; loop for next char

;;------------------------------------------------------------------------

msg_not_cpm22:
defb "Program can't run in this environment. CPM 2.2 is required$"

msg_insuffient_space:
defb "There is not enough space allocated. Use MOVCPM to allocate more space$"
msg_installed:
defb "Driver has been installed$"
