;    amstrad extra memory selection code 
;
;    Copyright (C) 2019  Kevin Thacker<kev@cpcfreak.co.uk>
;
;    This program is free software; you can redistribute it and/or modify
;    it under the terms of the GNU General Public License as published by
;    the Free Software Foundation; either version 2 of the License, or
;    (at your option) any later version.
;
;    This program is distributed in the hope that it will be useful,
;    but WITHOUT ANY WARRANTY; without even the implied warranty of
;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;    GNU General Public License for more details.
;
;    You should have received a copy of the GNU General Public License
;    along with this program; if not, write to the Free Software
;    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

;;-------------------------------------------------------------
;; Read from banked memory

;; Entry:
;; DHL = virtual memory address
;; Exit:
;; A = byte

bank_rd_byte:
push hl
call get_bank_addr
ld a,(hl)
pop hl
jp restore_bank0

;;-------------------------------------------------------------

restore_bank0:
push bc
ld bc,&7fc0
out (c),c
pop bc
ret


;;-------------------------------------------------------------
;; Write to banked memory
;;
;; Entry:
;; DHL = virtual memory address
;; A = byte
;; Exit:
;; 
bank_wr_byte:
push hl
call get_bank_addr
ld (hl),a
pop hl
jp restore_bank0


;;-------------------------------------------------------------
;; 
;; Entry:
;; DHL = address
;; Exit:
;; bank paged into 4000-7fff
;; HL = bank address
get_bank_addr:
push af
push de
push bc
push hl

ld	a,h
rla
rl	d
rla
rl	d
ld	a,d
;;sla h
;;rl d
;;sla h
;;rl d
;;ld a,d	;; 16kb block
ld hl,(mem_configs)
add a,l
ld l,a
ld a,h
adc a,0
ld h,a
ld a,(hl)
ld b,&7f
out (c),a
pop hl
ld a,h
and &3f
or &40
ld h,a
pop bc
pop de
pop af
ret

;;---------------------------------------------
;; Entry:
;; A = page number
select_page:
push hl
push bc
ld hl,(mem_configs)
add a,l
ld l,a
ld a,h
adc a,0
ld h,a
ld a,(hl)
ld b,&7f
out (c),a
pop bc
pop hl
ret


;;---------------------------------------------
;; points to list of useable configs which have been detected
mem_configs:
defw 0
;; number of memory configs detected
num_mem_configs:
defb 0
