;    Virtual memory read/write code for ZXZVM: Z-Code interpreter for the Z80 processor
;    Copyright (C) 2019  Kevin Thacker<kev@cpcfreak.co.uk>
;
;    This program is free software; you can redistribute it and/or modify
;    it under the terms of the GNU General Public License as published by
;    the Free Software Foundation; either version 2 of the License, or
;    (at your option) any later version.
;
;    This program is distributed in the hope that it will be useful,
;    but WITHOUT ANY WARRANTY; without even the implied warranty of
;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;    GNU General Public License for more details.
;
;    You should have received a copy of the GNU General Public License
;    along with this program; if not, write to the Free Software
;    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

;; Multiple virtual pages can map to the same page table entry.
;; If we need to load a new virtual page, then evict the one that
;; is currently mapped in the page table entry that the new one requires.

;;------------------------------------------------

VIRT_NUM_PAGES 		equ 32 ;; number of virtual pages in the page table. must be a multiple of 2

;; TODO: It may be faster to use a page size
;; which matches an exact sector size to reduce
;; the amount of conversion and deblocking.
;; Needs to be a multiple of 2.
PAGE_SIZE_BYTES    equ 512

;;------------------------------------------------
;; data per page
page_virtual_address  equ 0      			;; Z-Machine address (24-bit virtual address) aligned to PAGE_SIZE_BYTES
page_physical_address     equ page_virtual_address+3 	;; address in physical Z80 memory where this page is loaded
page_flags     equ page_physical_address+2    		;; indicates if page has been written to and must be commited if discarded
page_data_size     equ page_flags+1			;; size of all this data.

;;------------------------------------------------

