;    Virtual memory read/write code for ZXZVM: Z-Code interpreter for the Z80 processor
;    Copyright (C) 2019  Kevin Thacker<kev@cpcfreak.co.uk>
;
;    This program is free software; you can redistribute it and/or modify
;    it under the terms of the GNU General Public License as published by
;    the Free Software Foundation; either version 2 of the License, or
;    (at your option) any later version.
;
;    This program is distributed in the hope that it will be useful,
;    but WITHOUT ANY WARRANTY; without even the implied warranty of
;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;    GNU General Public License for more details.
;
;    You should have received a copy of the GNU General Public License
;    along with this program; if not, write to the Free Software
;    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

;; Use an age based metric to determine which page table entries can be evicted and re-used.

;;------------------------------------------------
;; Instead of using a last accessed time which would cause wrapping issues
;; with 8-bit numbers if the page hasn't been accessed for a while.
;; Use an age and cap it.

;; TODO: It may be more optimal to age this at other times rather than at each read/write access.
;; It seems to age the pages too fast meaning a page will get reused quickly.

MAX_PAGE_AGE    equ 254

;; TODO: It may be faster to use a page size
;; which matches an exact sector size to reduce
;; the amount of conversion and deblocking.
;; Needs to be a multiple of 2.
PAGE_SIZE_BYTES    equ 512

;;------------------------------------------------
;; data per page
page_virtual_address  equ 0      			;; Z-Machine address (24-bit virtual address) aligned to PAGE_SIZE_BYTES
page_physical_address     equ page_virtual_address+3 	;; address in physical Z80 memory where this page is loaded
page_flags     equ page_physical_address+2    		;; indicates if page has been written to and must be commited if discarded
page_age     equ page_flags+1   			;; age, effectively time since last access
page_data_size     equ page_age+1			;; size of all this data.
;;------------------------------------------------

