;    Virtual memory read/write test - caches to memory
;    Copyright (C) 2019  Kevin Thacker<kev@cpcfreak.co.uk>
;
;    This program is free software; you can redistribute it and/or modify
;    it under the terms of the GNU General Public License as published by
;    the Free Software Foundation; either version 2 of the License, or
;    (at your option) any later version.
;
;    This program is distributed in the hope that it will be useful,
;    but WITHOUT ANY WARRANTY; without even the implied warranty of
;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;    GNU General Public License for more details.
;
;    You should have received a copy of the GNU General Public License
;    along with this program; if not, write to the Free Software
;    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

;; NOTE: None of this has been optimised

include "virt.inc"

org &100

start:
;; setup 
ld hl,&8000
ld (virt_ram_start),hl
ld de,&8000+PAGE_SIZE_BYTES
ld (virt_ram_end),de

ld ix,page_table
ld hl,(virt_ram_start)
ld de,(virt_ram_end)
call virt_init

ld hl,0
ld d,0
call read_virtual
ld hl,3
ld d,0
call read_virtual
ld hl,PAGE_SIZE_BYTES
ld d,0
call read_virtual
ld a,&22
ld hl,4
ld d,0
call write_virtual
ld a,&33
ld hl,5
ld d,0
call write_virtual
ld a,&ee
ld hl,PAGE_SIZE_BYTES
ld d,0
call write_virtual
ld hl,PAGE_SIZE_BYTES
ld d,0
call read_virtual
ld hl,0
ld d,0
call read_virtual
ld hl,PAGE_SIZE_BYTES
ld d,0
call read_virtual
ret

page_table:
defb 0
defs 64*32



;;------------------------------------------------
;; IX = current page table entry

get_storage_addr:
ld h,(ix+page_virtual_address+1)
ld l,(ix+page_virtual_address+0)
ld de,virtual_storage
add hl,de
ret


;;------------------------------------------------
;; IX = current page table entry


store_virtual_page:
call get_storage_addr
call get_page_physical_address
ex de,hl
ld bc,PAGE_SIZE_BYTES
ldir
ret

;;------------------------------------------------
;; IX = current page table entry


restore_virtual_page:
call get_storage_addr
call get_page_physical_address
ld bc,PAGE_SIZE_BYTES
ldir
ret

virt_ram_start:
defw 0

virt_ram_end:
defw 0

virtual_storage:
include "virt.asm"

end start