org &100

esc equ 27
scr_set_border equ &bc38
txt_win_enable equ &bb66

scr_width equ 80
scr_height equ 24

start:
ld bc,0
call userf
defw scr_set_border

ld hl,cancel_wrap_str
call display_str

;; set string delimiter to &ff
ld c,&6e
ld d,0
ld e,&ff
call 5


call cls

;; top left
ld h,0
ld l,0
call set_cursor
ld a,'$'
call display_char

ld h,scr_width-1	
ld l,0
call set_cursor
ld a,'$'
call display_char
;; with wrap off this replaces char on line, there is no automatic go to next line
ld a,'$'
call display_char

ld h,scr_width-1
ld l,scr_height-2
call set_cursor
ld a,'$'
call display_char

ld h,20
ld l,20
call set_cursor
ld a,'&'
call display_char

;; define a window
ld h,1				
ld d,20				
ld l,1
ld e,10
call userf
defw txt_win_enable

ld a,'*'
call display_char

ld h,0
ld l,0
call set_cursor
ld a,'*'
call display_char


l1:
jp l1


display_char:
push hl
ld e,a
ld	c,2
call	5
pop hl
ret

output_string:
push hl
ld e,l
ld d,h
ld	c,9
call	5
pop hl
ret


display_str:
ds1:	
ld	a,(hl)
cp &ff
ret z
inc	hl
call display_char
jr	ds1

cls:
ld hl,clear_screen_str
call display_str
ret
	

set_cursor:
ld a,h
add a,' '
ld (set_cursor_x),a
ld a,l
add a,' '
ld (set_cursor_y),a

ld hl,set_cursor_str
call display_str
ret

;; due to the way the cpc's terminal is coded you can't 
;; send sequences a char at a time you must use a string print
clear_screen_str:	
defb	esc,'E',&ff

cancel_wrap_str:
defb esc,'w',&ff

set_cursor_str:	
defb	esc,'Y'

set_cursor_y: 
defb ' '

set_cursor_x: 
defb ' '
defb &ff

userf:	
push	hl	
push	de
ld	hl,(1)
ld	de,57h
add	hl,de
pop	de
ex	(sp),hl	
ret
