;    Virtual memory and swap file test 
;    Copyright (C) 2019  Kevin Thacker<kev@cpcfreak.co.uk>
;
;    This program is free software; you can redistribute it and/or modify
;    it under the terms of the GNU General Public License as published by
;    the Free Software Foundation; either version 2 of the License, or
;    (at your option) any later version.
;
;    This program is distributed in the hope that it will be useful,
;    but WITHOUT ANY WARRANTY; without even the implied warranty of
;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;    GNU General Public License for more details.
;
;    You should have received a copy of the GNU General Public License
;    along with this program; if not, write to the Free Software
;    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

;; NOTE: None of this has been optimised

DEBUG_OPCODE macro
	defb &ed,&ff
endm

include "virt.inc"

org &100

start:
ld de,start_test
ld c,9
call 5


ld hl,source_filename
ld b,end_source_filename-source_filename
call fill_in_fcb
ld hl,swap_fcb
ld de,a_fcb
ld bc,end_swap_fcb-swap_fcb
ldir

ld de,a_fcb
ld c,&0f
call bdos_swap
or a
jp nz,0
ld ix,a_fcb
ld (ix+&0c),0
ld (ix+&0f),0
ld (ix+&20),0


ld c,&1a   ;; disk transfer address/set dma address
ld de,buffer
call bdos_swap

ld de,a_fcb
ld c,&14 ;; read sequential
call bdos_swap


ld hl,&8000
ld (virt_ram_start),hl
ld de,&8000+PAGE_SIZE_BYTES
ld (virt_ram_end),de
defb &ed,&ff

ld hl,a_fcb
call swap_init
DEBUG_OPCODE

ld ix,page_table
ld hl,(virt_ram_start)
ld de,(virt_ram_end)
call virt_init
DEBUG_OPCODE

ld ix,page_table
call virt_reinit

ld hl,0
ld d,0
call read_virtual
ld (dat),a
DEBUG_OPCODE

ld hl,0
ld d,0
ld a,(dat)
cpl
call write_virtual
DEBUG_OPCODE

ld e,0
ld b,0
wv1:
push bc
push de
ld hl,0
ld d,15
push hl
push de
ld a,e
call write_virtual
pop de
pop hl
call read_virtual
cp e
jp nz,0
pop de
pop bc
djnz wv1
DEBUG_OPCODE

ld hl,PAGE_SIZE_BYTES
ld d,0
call read_virtual
DEBUG_OPCODE

ld hl,0
ld d,0
call read_virtual
DEBUG_OPCODE

ld c,a
ld a,(dat)
cpl
cp c
jp nz,0
DEBUG_OPCODE

call swap_reinit
DEBUG_OPCODE
call virt_reinit
DEBUG_OPCODE
ld hl,0
ld d,0
call read_virtual
DEBUG_OPCODE
ld c,a
ld a,(dat)
cp c
jp nz,0
DEBUG_OPCODE

call swap_finish

;; close swap fcb
ld de,a_fcb
ld c,&10
call bdos_swap
ld c,9
ld de,ok_str
call 5
jp 0

source_filename:
defb "CPCZVM.COM"
end_source_filename:

start_test:
defb "Starting test$"

ok_str:
defb "Test all ok$"


dat:
defb 0


virt_ram_start:
defw 0

virt_ram_end:
defw 0

include "virt.asm"
include "swap.asm"

a_fcb:
defs 64

page_table:
defb 0
defs 64*32

end start