;; Resident driver
;;
;; - Amstrad CP/M only (because it relies on specific addresses)
;; - CPM 2.2 only
;; - Uses MOVCPM to allocate space.

include "driver_common.asm"

pages_wanted equ (end_driver_code-driver_code+255)/256

;;------------------------------------------------------------------------

org &100

start:
;; check cp/m version
ld c,&0c
call bdos
ld a,l
cp &22
jr z,is_cpm22

;; it's not 2.2
ld hl,msg_not_cpm22
call display_message

;; and quit
ret

;;------------------------------------------------------------------------

is_cpm22:
ld a,(&0007)	;; upper byte of BDOS address
sub &0a		;; take into account size of CCP in pages
cp pages_wanted
jr nc,enough_space

ld hl,msg_insuffient_space
call display_message
ret

;;------------------------------------------------------------------------

enough_space:
ld a,(&0007)
sub &0a
sub pages_wanted
ld h,a
ld l,0
push hl
ex de,hl
ld hl,driver_code
ld bc,end_driver_code-driver_code
ldir
pop hl
ld bc,6
add hl,bc
call callhl
ld hl,msg_installed
call display_message
ret
callhl:
jp (hl)
;;------------------------------------------------------------------------

;; ideally this is prl and we relocate it into place.
driver_code:
incbin "driver_code.bin"
end_driver_code

;;------------------------------------------------------------------------

display_char:
push hl
ld c,2			;; console output function id
ld e,a			;; ASCII character
call bdos		;; call BDOS to execute function
pop hl
ret

;;------------------------------------------------------------------------

;; HL = pointer to null terminated message
display_message:
ld a,(hl)				;; get ASCII character
inc hl					;; increment pointer for next character
cp "$"					;; end of message marker
ret z					;; quit if end of message marker found.

call display_char		;; send character to console output
jp display_message		;; loop for next char

;;------------------------------------------------------------------------

msg_not_cpm22:
defb "Program can't run in this environment. CPM 2.2 is required$"

msg_insuffient_space:
defb "There is not enough space allocated. Use MOVCPM to allocate more space$"
msg_installed:
defb "Driver has been installed$"
