;;------------------------------------------------------------------------------------------------------------

;; ideally this is prl code and is relocated into space.
;; 
;; wboot doesn't return.
;; calling and then installing our code will not work.
;; it appears "enter firmware" could be patched and wboot detected and re-installed

;;------------------------------------------------------------------------------------------------------------

;; A>C:
;; first it seems to do a read/write of A
;; seldsk
;; home
;; setdma
;; sectran
;; settrk
;; setsec
;; read

org &7b00
include "driver_common.asm"

;;------------------------------------------------------------------------------------------------------------

cpm_sector_size equ 128
cpm_bdos_jumpblock_size equ &33

;;------------------------------------------------------------------------------------------------------------
driver_bdos:
jp bdos_handler	;; our handler calls the base one, this is purely here to define top of TPA
defs 3			;; this is mainly to help x-sub
jp driver_init

bdos_handler:
jp old_bdos

driver_init:
;; install our bdos, thereby reducing tpa.
ld hl,&0005
ld de,old_bdos
ld bc,3
ldir
;; install our bdos
ld a,&c3
ld hl,driver_bdos
ld (&0005),a
ld (&0006),hl

;; now copy jumpblock and patch it for our use

ld hl,(1)	;; this is the address of the JP for wboot
or a
ld de,3
sbc hl,de
;; HL = JP for boot
push hl
ld de,jumpblock_copy
ld bc,cpm_bdos_jumpblock_size
ldir
pop hl

;; now patch
;;ld bc,cpm_boot
;;ld de,patched_boot
;;call patch

;;ld bc,cpm_wboot
;;ld de,patched_wboot
;;call patch

ld bc,cpm_home
ld de,patched_home
call patch

ld bc,cpm_seldsk
ld de,patched_seldsk
call patch

ld bc,cpm_settrk
ld de,patched_settrk
call patch

ld bc,cpm_setsec
ld de,patched_setsec
call patch

ld bc,cpm_setdma
ld de,patched_setdma
call patch

ld bc,cpm_read
ld de,patched_read
call patch

ld bc,cpm_write
ld de,patched_write
call patch

ld bc,cpm_sectran
ld de,patched_sectran
call patch
ret

;;------------------------------------------------------------------------------------------------------------
patch:
push hl
add hl,bc
ld a,&c3
ld (hl),a
inc hl
ld (hl),e
inc hl
ld (hl),d
pop hl
ret

;;------------------------------------------------------------------------------------------------------------

;; From seasip.info:
;;SETTRK (function 10)
;;
;;Set the track in BC - 0 based.

patched_settrk:
call is_current_drive_ours
jp c,jumpblock_copy+cpm_settrk
ld (track),bc
ret

;;------------------------------------------------------------------------------------------------------------

;; From seasip.info:
;;SETSEC (function 11)
;;
;;Set the sector in BC. Under CP/M 1 and 2 a sector is 128 bytes. Under CP/M 3 the sector size is given in the Disk Parameter Block.
patched_setsec:
call is_current_drive_ours
jp c,jumpblock_copy+cpm_setsec
ld (sec),bc
ret

;;------------------------------------------------------------------------------------------------------------
;; From seasip.info:
;;SETDMA (function 12)
;;
;;The next disc operation will read its data from (or write its data to) the address given in BC.

patched_setdma:
call is_current_drive_ours
jp c,jumpblock_copy+cpm_setdma
ld (dma),bc
ret

;;------------------------------------------------------------------------------------------------------------
;; From seasip.info:
;;BOOT (function 0)
;;
;;This function is completely implementation-dependent and should never be called from user code.

patched_boot:
push hl
push af
ld hl,log_boot
call display_message
pop af
pop hl
jp jumpblock_copy+cpm_boot


;;------------------------------------------------------------------------------------------------------------
;; From seasip.info:
;;WBOOT (function 1)
;;
;;Reloads the command processor and (on some systems) the BDOS as well. How it does this is implementation-dependent; it may use the reserved tracks of a floppy disc or extra memory.
patched_wboot:
;; do normal wboot
call jumpblock_copy+cpm_wboot
;; repatch jump block
call driver_init
ret


;;------------------------------------------------------------------------------------------------------------
;; From seasip.info:
;; SELDSK
;; Select the disc drive in register C (0=A:, 1=B: ...). Called with E=0 or 0FFFFh.
patched_seldsk:
;; is it one of our drives?
ld a,c
cp first_drive
jp c,jumpblock_copy+cpm_seldsk
cp last_drive+1
jp nc,jumpblock_copy+cpm_seldsk
;; yes it is, return the dph for our drives
ld a,c
sub first_drive
add a,a
add a,dphlist AND 255
ld l,a
ld a,dphlist/256
adc a,0
ld h,a
ld a,(hl)
inc hl
ld h,(hl)
ld l,a		;; return DPH
ret

;;----------------------------------------------------------------------------------------------

is_current_drive_ours:
ld a,(drive_user) ;; read current drive/user
and &f
cp first_drive
ret c
cp last_drive+1	;; if nc then it's greater and not our drive
				;; if c it is our drive
ccf
ret

;;----------------------------------------------------------------------------------------------
;; Each CPM2.2 sector is 128 bytes
;; Each IDE sector is 512 bytes.
;; There are 4 CPM2.2 sectors per IDE sector.
;;
;; X-MASS has 128MB drive
;; ‭134217728‬ bytes
;; 262,144 IDE sectors
;; ‭1048576‬ CPM2.2 sectors.

;;----------------------------------------------------------------------------------------------
;;READ (function 13)

;;Read the currently set track and sector at the current DMA address. Returns A=0 for OK, 1 for unrecoverable error, 0FFh if media changed.

patched_read:
call is_current_drive_ours
jp c,jumpblock_copy+cpm_read

;; fake read
ld hl,(dma)
ld bc,cpm_sector_size
read1:
ld (hl),&e5
inc hl
dec bc
ld a,b
or c
jr nz,read1
xor a
ret

;;-----------------------------------------------------------------------------------------------------------
;;
;; From seasip.info:
;;SECTRAN (function 16)
;;
;;Translate sector numbers to take account of skewing.
;;
;;On entry, BC=logical sector number (zero based) and DE=address of translation table. On exit, HL contains physical sector number. On a system with hardware skewing, this would normally ignore DE and return either BC or BC+1.
patched_sectran:
call is_current_drive_ours
jp c,jumpblock_copy+cpm_sectran
ld l,c
ld h,b
ret


;;-----------------------------------------------------------------------------------------------------------
;; seasip.info:
;;WRITE (function 14)
;;
;;Write the currently set track and sector. C contains a deblocking code:
;;
patched_write:
call is_current_drive_ours
jp c,jumpblock_copy+cpm_write
;; it's our drive

;; fake write
xor a
ret


;;-----------------------------------------------------------------------------------------------------------
;; seasip.info:
;;WRITE (function 14)
;;
;;Write the currently set track and sector. C contains a deblocking code:
;;
patched_home:
call is_current_drive_ours
jp c,jumpblock_copy+cpm_home
;; it's our drive

;; set track 0
ld bc,0
ld (track),a
ret

;;-----------------------------------------------------------------------------------------------

jumpblock_copy:
defs cpm_bdos_jumpblock_size

;;-----------------------------------------------------------------------------------------------
dphlist:
defw dph_c
defw dph_d
defw dph_e
defw dph_f

;;-----------------------------------------------------------------------------------------------

dph_c:
defw 0	;; address of xlt
defw 0,0,0	;; used as workspace for cpm
defw dirbuf		;; dirbuf
defw dpb_c	;; dpb
defw 0		;; csv
defw drv_c_alv		;; alv



dph_d:
defw 0	;; address of xlt
defw 0,0,0	;; used as workspace for cpm
defw dirbuf		;; dirbuf
defw dpb_d	;; dpb
defw 0		;; csv
defw drv_d_alv		;; alv


dph_e:
defw 0	;; address of xlt
defw 0,0,0	;; used as workspace for cpm
defw dirbuf		;; dirbuf
defw dpb_e	;; dpb
defw 0		;; csv
defw drv_e_alv		;; alv


dph_f:
defw 0	;; address of xlt
defw 0,0,0	;; used as workspace for cpm
defw dirbuf		;; dirbuf
defw dpb_f	;; dph
defw 0		;; csv
defw drv_f_alv		;; alv

drv_c_alv:
;;defs 1024
drv_d_alv:
;;defs 1024
drv_e_alv:
;;defs 1024
drv_f_alv:
defs 1024

dpb_c:
defw 10	;; spt
defb 3	;; bsh
defb 7	;; blm
defb 0 	;; exm
defw 100	;; dsm
defw 64	;; drm
defb &c0 ;; al0
defb 0 	;; al1
defw 0	;; cks
defw 0	;; off


dpb_d:
defw 10	;; spt
defb 3	;; bsh
defb 7	;; blm
defb 0 	;; exm
defw 100	;; dsm
defw 64	;; drm
defb &c0 ;; al0
defb 0 	;; al1
defw 0	;; cks
defw 100	;; off


dpb_e:
defw 10	;; spt
defb 3	;; bsh
defb 7	;; blm
defb 0 	;; exm
defw 100	;; dsm
defw 64	;; drm
defb &c0 ;; al0
defb 0 	;; al1
defw 0	;; cks
defw 200	;; off


dpb_f:
defw 10	;; spt
defb 3	;; bsh
defb 7	;; blm
defb 0 	;; exm
defw 100	;; dsm
defw 64	;; drm
defb &c0 ;; al0
defb 0 	;; al1
defw 0	;; cks
defw 400	;; off

dirbuf:
defs 128

track:
defw 0
sec:
defw 0
dma:
defw 0

old_bdos:
defs 3

;;------------------------------------------------------------------------

display_char:
push hl
ld c,2			;; console output function id
ld e,a			;; ASCII character
call bdos		;; call BDOS to execute function
pop hl
ret

;;------------------------------------------------------------------------

;; HL = pointer to null terminated message
display_message:
ld a,(hl)				;; get ASCII character
inc hl					;; increment pointer for next character
cp "$"					;; end of message marker
ret z					;; quit if end of message marker found.

call display_char		;; send character to console output
jp display_message		;; loop for next char

log_boot:
defb "Seen boot$"
